const app_config = require( './configs/app_config' );
const sentry = require( './components/sentry' );
const some_diskusage = require( './components/some_diskusage' );
const { app } = require( 'electron' );
const getCountProcessByName = require( './method/getCountProcessByName' );
const hostinfo = require( './components/hostinfo' );
const QueueLoad = require( './components/QueueLoad' );
require( './components/MonitoringScreeningProcecc' );
const CacheLoad = require( './components/CacheLoad' );
const parseRecordFilename = require( './components/parseRecordFilename' );

sentry.setCapture( true );

getCountProcessByName( 'screenrecord_client.exe' ).then( cnt => {
  if ( cnt > 2 ) {
    console.log( `instance_count ${ cnt }...app.quit` );
    app.quit();
    return false;
  }
  const db = require( './components/db' );
  const fileinfo = require( './components/fileinfo' );
  const get_datetime_ekb = require( './method/get_datetime_ekb' );
  const { spawn } = require( 'child_process' );
  const fs = require( 'fs' );
  const AdmZip = require( 'adm-zip' );
  const fetch = require( 'node-fetch' );
  const socket_client = require( './components/socket_client' );
  const record_dir_watcher = require( './components/record_dir_watcher' );
  const record_info_sent_watcher = require( './components/record_info_sent_watcher' );
  const diskusage_watcher = require( './components/diskusage_watcher' );
  const records_diff_disk_db = require( './components/records_diff_disk_db' );
  const appinfo = require( './components/appinfo' );
  const random = require( './components/random' );

  //todo ждать проверку обновления и только потом все остальное
  check_update();

  db.getHostUid().then( ( uid ) => hostinfo.uid( uid ) );
  CacheLoad.on( 'loadFileSuccess', ( item ) => {
    console.log( 'CacheLoad.loadFileSuccess', item );
    socket_client.emit( 'CacheLoad.loadFileSuccess', item );
  } );
  //todo делать это если получил настройку об сервере-кэша
  db.getNotCachedRecords().then( ( rows ) => rows.forEach( ( r ) => CacheLoad.add( r ) ) ).catch( ( err ) => sentry.captureException( err ) );
  diskusage_watcher.init( ( { record_created, session_id } ) => {
    socket_client.emit( 'set_deleted_record', ({ record_created, session_id }) );
  } );
  record_dir_watcher.onFile( ( file_obj ) => {
    const { file, record_created } = file_obj;
    console.log( 'record_dir_watcher.onFile', file_obj );
    const record = parseRecordFilename( file );
    if ( record ) {
      record.record_created = record_created;
      console.log( 'db.addRecord', record );
      db.addRecord( record );
      CacheLoad.add( record );
    }
  } );
  record_info_sent_watcher.onNoSentRecords( ( records ) => {
    const host_id = hostinfo.get_host_id();
    console.log( 'host_id', host_id );
    if ( host_id ) {
      const data = {
        records,
        host_id
      };
      console.log( 'add_records', data );
      socket_client.emit( 'add_records', data );
    }
  } );
  records_diff_disk_db.then( ( { files_diff_db, files_diff_disk } ) => {
    const next = () => {
      if ( socket_client.disconnected() ) return setTimeout( next, 1000 * 60 );
      const files_diff_db_next = files_diff_db.splice( 0, 100 );
      if ( files_diff_db_next.length > 0 ) {
        console.log( 'records_diff_disk_db', files_diff_db );
        socket_client.emit( 'records_diff_disk_db', { files_diff_db: files_diff_db_next } );
        setTimeout( next, 1000 * 60 * 30 );
      }
    };
    next();
    files_diff_disk.forEach( ( file ) => {
      fileinfo( file ).then( ( info ) => {
        const record = parseRecordFilename( file );
        if ( record ) {
          record.record_created = get_datetime_ekb( info.birthtime );
          db.addRecord( record );
          CacheLoad.add( record );
        }
      } ).catch( err => sentry.captureException( err ) );
    } );
  } ).catch( err => sentry.captureException( err ) );
  socket_client.on( 'connect', () => {
    console.log( 'socket_client.connect' );
  } );
  socket_client.on( 'CacheLoad.loadFileSuccess', ( item ) => {
    db.cachedRecord( item );
  } );
  socket_client.on( 'disconnect', () => {
    console.log( 'socket_client.disconnect' );
    hostinfo.set_host_config( {} );
  } );
  socket_client.on( 'host_config', ( { config } ) => {
    console.log( 'host_config ', config );
    hostinfo.set_host_config( config );
    CacheLoad.setConfigServer( hostinfo.getCacheConfig() );
    if ( !config.host_id ) emitHostInfo();
  } );
  socket_client.on( 'add_record_success', ( { record } ) => {
    const { session_id, record_created } = record;
    db.complete_sent_record( { session_id, record_created } );
    console.log( 'add_record_success', record );
  } );
  socket_client.on( 'set_deleted_record_success', ( { record } ) => {
    db.set_delete_record( record );
    console.log( 'set_deleted_record_success', record );
  } );
  socket_client.on( 'updateQueueLoad', ( { records } ) => {
    const records_group = {};
    const ids = [];
    records.forEach( ( record ) => {
      const { session_id, record_created } = record;
      records_group[session_id + record_created] = record;
      ids.push( session_id );
    } );
    db.getRecordsBySessionIds( { ids } ).then( ( items ) => {
      items.forEach( ( item ) => {
        const { session_id, record_created, file } = item;
        const record = records_group[session_id + record_created];
        if ( record )
          QueueLoad.add( { ...record, ...{ file } } )
      } );
    } ).catch( ( err ) => {
      console.log( 'getRecordsBySessionIds', err );
      if ( err )
        sentry.captureException( err );
    } );
  } );

  QueueLoad.on( 'record_deleted', ( { record } ) => socket_client.emit( 'load_record.deleted', { record } ) );
  QueueLoad.on( 'start_load', ( { record } ) => socket_client.emit( 'load_record.start_load', { record } ) );
  QueueLoad.on( 'end_load', ( { record } ) => socket_client.emit( 'load_record.end_load', { record } ) );
  QueueLoad.on( 'error_load', ( { record } ) => socket_client.emit( 'load_record.error_load', { record } ) );

  function check_update() {
    const URL_REPOSITORY = 'https://soft.contact-centre.ru';
    const MICROUPDATES_DIR = 'srcl_updates';
    Promise.all( [
      fetch( `${ URL_REPOSITORY }/srcl.json` ).then( ( res ) => {
        if ( res.status !== 200 ) throw res.status;
        return res.json();
      } ),
      new Promise( ( resolve, reject ) => fs.readFile( __dirname + '/package.json', 'utf8',
        ( error, content ) => {
          if ( error ) return reject( error );
          resolve( JSON.parse( content ) );
        } ) )
    ] ).then( ( res ) => {
      const EXE_FILE = 'srcl.exe';
      const now_version = res[0].version;
      const chance = res[0].chance;
      const THIS_VERSION = res[1].version;
      console.log( now_version, THIS_VERSION );
      if ( now_version !== THIS_VERSION && random( 0, chance ) === 0 ) {
        console.log( 'update' );
        const ZIP_FILE = `${ THIS_VERSION }.zip`;
        const ZIP_FILE_PATH = `${ app_config.record_path() }/${ ZIP_FILE }`;

        fetch( `${ URL_REPOSITORY }/${ MICROUPDATES_DIR }/${ ZIP_FILE }` )
          .then( ( res ) => {
            if ( res.status !== 200 ) throw res.status;
            return res.buffer();
          } )
          .then( ( buffer ) => {
            console.log( 'download_zip_file', buffer, typeof buffer );
            fs.writeFile( ZIP_FILE_PATH, buffer, ( error ) => {
              setTimeout( check_update, hostinfo.get_update_timeout() );
              if ( error ) return;
              const zip = new AdmZip( ZIP_FILE_PATH );
              zip.extractAllTo( __dirname, true );
              process.exit( -1 );
            } );
          } )
          .catch( ( e ) => {
            console.log( 'error update: download_zip_file', e );
            const EXE_FILE_UPD = 'srcl_upd.exe';
            const EXE_REMOTE_FILE_UPD = `srcl_upd_${ THIS_VERSION }.exe`;
            fetch( `${ URL_REPOSITORY }/${ EXE_REMOTE_FILE_UPD }` )
              .then( res => {
                if ( res.status !== 200 ) throw res.status;
                return res.buffer();
              } )
              .then( buffer => {
                console.log( 'download_exe_file' );
                fs.writeFile( `${ app_config.record_path() }/${ EXE_FILE_UPD }`, buffer, ( error ) => {
                  setTimeout( check_update, hostinfo.get_update_timeout() );
                  if ( error ) return;
                  spawn( __dirname + `/installer_upd.bat`, {
                    detached: true,
                    stdio: 'ignore'
                  } );
                } );
              } )
              .catch( ( e ) => {
                console.log( 'error update: download_exe_file_upd', e );
                fetch( `${ URL_REPOSITORY }/${ EXE_FILE }` )
                  .then( res => {
                    if ( res.status !== 200 ) throw res.status;
                    return res.buffer();
                  } )
                  .then( buffer => {
                    console.log( 'download_exe_file' );
                    fs.writeFile( `${ app_config.record_path() }/${ EXE_FILE }`, buffer, ( error ) => {
                      setTimeout( check_update, hostinfo.get_update_timeout() );
                      if ( error ) return;
                      spawn( __dirname + `/installer.bat`, {
                        detached: true,
                        stdio: 'ignore'
                      } );
                    } );
                  } )
                  .catch( ( e ) => {
                    console.log( 'error update: download_exe_file', e );
                    setTimeout( check_update, hostinfo.get_update_timeout() );
                  } );
              } );
          } );
      } else {
        console.log( 'wait' );
        setTimeout( check_update, hostinfo.get_update_timeout() );
      }
    } ).catch( ( e ) => {
      setTimeout( check_update, hostinfo.get_update_timeout() );
      console.log( 'error update: ', e );
    } );
  }

  function emitHostInfo() {
    const { hostname, mac, ipv4, platform, uid } = hostinfo;
    const { version } = appinfo;
    const hostinfo_data = {
      host: {
        name: hostname(),
        mac: mac(),
        ipv4: ipv4(),
        uid: uid(),
        platform: platform()
      },
      app: { version: version() }
    };

    some_diskusage().then( ( disk ) => {
      hostinfo_data.disk = {
        total: disk.total,
        free: disk.available
      };
      console.log( 'hostinfo_data', hostinfo_data );
      socket_client.emit( 'hostinfo', hostinfo_data );
    } );
  }

  console.log( 'app ready' );

// function createWindow() {
//   let win = new BrowserWindow( { width: 800, height: 600 } );
//   win.loadFile( __dirname + '/index.html' );
//   win.webContents.openDevTools();
//   app.on( 'window-all-closed', function() {
//     // Mac OS X - close is done explicitly with Cmd + Q, not just closing windows
//     if ( process.platform != 'darwin' ) {
//       app.quit();
//     }
//   } );
// }
//
// app.on( 'ready', createWindow );
} );

