const io = require( 'socket.io-client' );
const io_config = require( './../configs/io_config' );

const host_port = io_config.host + ':' + io_config.port;
const socket_client = io.connect( host_port, { secure: true, reconnect: true, rejectUnauthorized: false } );

module.exports = (function() {
  return {
    on: ( action, callback ) => socket_client.on( action, callback ),
    emit: ( action, data ) => socket_client.emit( action, data ),
    socket: () => socket_client,
    disconnected: () => socket_client.disconnected
  }
})();