const Client = require( 'ssh2-sftp-client' );
const fs = require( 'fs' );
const hostinfo = require( './hostinfo' );

module.exports = {
  send_file( file, target_path, target_name ) {
    const sftp = new Client();
    const sftp_config = hostinfo.get_sftp_config();
    return sftp.connect( sftp_config )
      .then( () => sftp.exists( sftp_config.root_dir + target_path ) )
      .then( ( data ) => {
        if ( data ) return true;
        const recursive = true;
        return sftp.mkdir( sftp_config.root_dir + target_path, recursive );
      } ).then( () => {
        return sftp.put( file, sftp_config.root_dir + target_path + '/' + target_name );
      } ).then( () => sftp.end() );
  },
  sendFile( config, file, target_path, target_name ) {
    const sftp = new Client();
    return sftp.connect( config )
      .then( () => sftp.exists( config.root_dir + target_path ) )
      .then( ( data ) => {
        if ( data ) return true;
        const recursive = true;
        return sftp.mkdir( config.root_dir + target_path, recursive );
      } ).then( () => {
        return sftp.put( file, config.root_dir + target_path + '/' + target_name );
      } ).then( () => sftp.end() );
  }
};