const R = require( 'ramda' );
const glob = require( 'glob' );
const app_config = require( './../configs/app_config' );
const db = require( './db' );
const get_now_date = require( './get_now_date' );

function get_all_files_on_disk() {
  return new Promise( ( resolve, reject ) => {
    glob( app_config.record_path() + '/**/*.mkv',
      { strict: false, silent: true, ignore: app_config.record_path() + '/$RECYCLE.BIN/**/*.mkv' }, ( err, files ) => {
        if ( err ) {
          reject( err );
          return false;
        }
        resolve( files );
      } );
  } );
}

module.exports = get_all_files_on_disk().then( files_on_disk => {
  const now_date = get_now_date();
  const files_on_disk_without_now_date = files_on_disk.filter( file => file.indexOf( now_date ) === -1 );
  return db.get_not_deleted_records().then( not_deleted_records => {
    console.log( 'not_deleted_records', not_deleted_records );
    let record_in_db = {};
    let files_in_db = [];

    not_deleted_records.forEach( record => {
      record_in_db[record.file] = record;
      files_in_db.push( record.file );
    } );
    // есть на диске и нет в базе
    const files_diff_disk = R.difference( files_on_disk_without_now_date, files_in_db );
    console.log( 'files_diff_disk', files_diff_disk );
    // есть в базе и нет на диске
    const files_diff_db = R.difference( files_in_db, files_on_disk_without_now_date ).map( item => record_in_db[item] );
    console.info( 'files_diff_db', files_diff_db );
    return { files_diff_db, files_diff_disk };
  } );
} );
