const sentry = require( './sentry' );
const db = require( './db' );
const interval_msec = 60 * 1000;
const last_sent_interval_min = 300000;
let onNoSentRecordsCallbacks = [];
let cache = {};

setInterval( () => {
  console.log( 'record_info_sent_watcher.setInterval()' );
  db.get_nosent_records().then( ( records ) => {
    let nosent_records = [];
    const now = Date.now();
    records.forEach( record => {
      if ( !cache[record.record_created] ) {
        cache[record.record_created] = record;
        cache[record.record_created].last_sent_timestamp = now;
        nosent_records.push( record );
      }
    } );
    Object.keys( cache ).forEach( record_created => {
      if ( Date.now() - cache[record_created].last_sent_timestamp > last_sent_interval_min ) {
        console.log( 'delete ' + record_created );
        delete cache[record_created];
      }
    } );
    console.log( nosent_records );
    if ( nosent_records.length === 0 ) return;
    onNoSentRecordsCallbacks.forEach( cb => cb( nosent_records ) )
  } ).catch( err => sentry.captureException( err ) );
}, interval_msec );

module.exports = (function() {
  return {
    onNoSentRecords( callback ) {
      onNoSentRecordsCallbacks = [];
      onNoSentRecordsCallbacks.push( callback );
    }
  }
})();