const get_datetime_ekb = require( './../method/get_datetime_ekb' );
const fileinfo = require( './../components/fileinfo' );
const app_config = require( './../configs/app_config' );
const chokidar = require( 'chokidar' );
const watcher = chokidar.watch( app_config.record_path(), { ignorePermissionErrors: true, ignoreInitial: true } );
const interval_msec = 10 * 1000;
let onFileCallbacks = [];
let cache = {};
watcher.on( 'add', fileWatcher ).on( 'change', fileWatcher );

setInterval( () => {
  Object.keys( cache ).forEach( ( file ) => {
    fileinfo( file ).then( ( info ) => {
      const { size } = info;
      const file_obj = cache[file];
      if ( size === file_obj.size ) {
        onFileCallbacks.forEach( cb => {
          cb( file_obj );
        } );
        delete cache[file];
      } else {
        cache[file].size = size;
      }
    } ).catch( err => console.log( err ) );
  } );
}, interval_msec );

function addNewFile( file, stats ) {
  const file_path = file.replace( /\\/g, '/' );
  if ( cache[file_path] ) return;
  console.log( 'addNewFile', file_path );
  cache[file_path] = {
    file: file_path,
    size: 0,
    timestamp: Date.now(),
    record_created: get_datetime_ekb( stats.birthtime )
  };
}

module.exports = (function() {
  return {
    onFile( callback ) {
      onFileCallbacks.push( callback );
    }
  }
})();

function fileWatcher( file, stats ) {
  if ( file.indexOf( '.mkv' ) > -1 ) {
    addNewFile( file, stats );
  }
}