const Websocket=require('websocket').w3cwebsocket;
module.exports = (_cti_params) => {
  const CTI_PARAMS = _cti_params || {};
  const CTI_URL = CTI_PARAMS.URL || 'ws://127.0.0.1:9002';
  const CTI_PROTOCOL_VERSION = CTI_PARAMS.PROTOCOL_VERSION || 9;
  const CTI_PROTOCOL = CTI_PARAMS.PROTOCOL || 'nauphone-softphone-protocol';
  let WS = null;
  let RID = 0;
  let observers = {};

 function connect() {
    WS = new Websocket(CTI_URL, CTI_PROTOCOL);
    WS.onopen = () => {
      dispatch('open');
      setProtocolVersion(CTI_PROTOCOL_VERSION);
    };
    WS.onclose = () => {
      setTimeout( connect, 5000 );
      dispatch('close');
    };
    WS.onmessage = (_event) => {
      // console.log(_event);
      const message = parseMessage(_event.data);
      if (typeof message.rid !== 'undefined') {
        dispatch(message.rid, message);
        return false;
      }
      dispatch(message.name, message)
    };
    WS.onerror = (_event) => {
      console.log(_event);
    };
  }

	function setProtocolVersion(_protocol_version) {
	    let message = {
	      rid: 'setProtocolVersion',
	      name: 'setProtocolVersion',
	      'protocolVersion': _protocol_version
	    };
	    send(message);
	  }


  function prepareMessage(_message) {
    return JSON.stringify(_message);
  }

  function parseMessage(_message) {
    return JSON.parse(_message);
  }

  function on(_event, _callback) {
    if (typeof _callback !== 'function') {
      return false;
    }
    if (typeof observers[_event] !== 'object') {
      observers[_event] = [];
    }
    observers[_event].push(_callback);
  }

  function dispatch(_event, _params) {
    console.log(_event);
    if (typeof observers[_event] !== 'object') {
      return false;
    }
    observers[_event].forEach((_event) => {
      if (typeof _event === 'function') {
        _event(_params);
      }
    });
  }

  function send(_message) {
    if (WS === null) {
      return false;
    }
    WS.send(prepareMessage(_message));
  }

  return {
  	connect,
  	on,
    send
  };
};