const matchAll = require( 'match-all' );
const md5 = require( 'md5' );
module.exports = function( file ) {
  console.log( 'parseRecordFilename', file );
  let data = parse_record_filename( file );
  if ( data.session_id ) {
    return { session_id: data.session_id, naumen_id: data.naumen_id, file, login: data.login };
  }
  data = parse_record_filename2( file );
  if ( data.session_id ) {
    return { session_id: data.session_id, naumen_id: data.naumen_id, file, login: data.login };
  }
  return null;
};

function parse_record_filename( filename ) {
  const regexp = /\(([\w-.]+)\)/g;
  const filename_parts = matchAll( filename, regexp ).toArray();
  console.log( filename_parts )
  let naumen_id = null;
  let session_id = null;
  let login = null;
  if ( [ 3, 4 ].includes( filename_parts.length ) ) {
    naumen_id = filename_parts[1];
    login = filename_parts[2];
    if ( filename_parts[3] ) {
      session_id = filename_parts[3];
    } else {
      session_id = md5( filename );
    }
  }
  return {
    naumen_id,
    session_id,
    login
  };
}

function parse_record_filename2( filename ) {
  const regexp = /\/([\w-.]+)/g;
  const filename_parts = matchAll( filename, regexp ).toArray();
  console.log( filename_parts )
  let naumen_id = null;
  let session_id = null;
  let login = null;
  if ( filename_parts.length === 4 ) {
    naumen_id = 0;
    login = filename_parts[1];
    session_id = filename_parts[3].split( '-' )[4].replace( '.mkv', '' );
    if ( session_id.length === 0 ) {
      session_id = md5( filename );
    }
  }
  return {
    naumen_id,
    session_id,
    login
  };
}