const ip_convert = require( './ip_convert' );
const os = require( 'os' );
let config = {};
let cache_config = {};
let ipv4 = null;
let mac = null;
let uid = null;
module.exports = {
  isWin,
  platform() {
    return os.platform();
  },
  hostname() {
    return os.hostname();
  },
  ipv4: () => ipv4,
  mac: () => mac,
  uid: ( id ) => id ? uid = id : uid,
  get_host_id() {
    return config.host_id ? config.host_id : null;
  },
  set_host_config( _config ) {
    ipv4 = null;
    mac = null;
    config = _config;
    cache_config = {};
    if ( config.ip_pair_range ) {
      config.ip_pair_range.forEach( ( ip_pair ) => {
        ip_pair.first = ip_convert.inet_aton( ip_pair.first );
        ip_pair.last = ip_convert.inet_aton( ip_pair.last );
      } );
      const interfaces = os.networkInterfaces();
      Object.keys( interfaces ).forEach( key => {
        interfaces[key].forEach( ( iface ) => {
          const ip_pair_range = getIpPairRangeByIp( iface.address );
          if ( iface.family === 'IPv4' && iface.internal === false && ip_pair_range ) {
            ipv4 = iface.address;
            mac = iface.mac;
            cache_config = ip_pair_range.cache;
          }
        } );
      } );
    }
  },
  get_sftp_config() {
    return config.sftp;
  },
  getCacheConfig() {
    return cache_config;
  },
  get_update_timeout() {
    return config.update_timeout ? config.update_timeout * 1000 : 1800 * 1000;
  },
  get_lock_screen_timeout() {
    return config.lock_screen_timeout ? config.lock_screen_timeout * 1000 : 30 * 1000;
  },
  get_disk_available_gb
};

function get_disk_available_gb() {
  return config.host_disk_available_gb ? config.host_disk_available_gb : null;
}

function isWin() {
  return /^win/i.test( os.platform() );
}

function getIpPairRangeByIp( ip ) {
  if ( !config.ip_pair_range ) return null;
  const ip_this = ip_convert.inet_aton( ip );
  for ( let ip_pair of config.ip_pair_range ) {
    if ( ip_pair.first <= ip_this && ip_pair.last >= ip_this ) return ip_pair;
  }
  return null;
}