const some_diskusage = require( './some_diskusage' );
const fs = require( 'fs' );
const sentry = require( './sentry' );
const byte_to_gb = require( './byte_to_gb' );
const hostinfo = require( './hostinfo' );
const db = require( './db' );
const interval_msec = 3600000;
module.exports = (() => {
  return { init };
})();

function init( cb ) {
  setInterval( () => {
    get_diskusage().then( clear_disk => {
      if ( clear_disk ) {
        db.get_not_deleted_records().then( records => {
          let all_size = 0;
          records.some( ( { file, session_id, record_created } ) => {
            if ( byte_to_gb( all_size ) > 1 ) {
              return true;
            }
            fs.unlink( file, ( err ) => {
              if ( err ) return console.log( err );
              db.set_delete_record( { record_created, session_id } );
              if ( typeof cb === 'function' )
                cb( { record_created, session_id } );
            } );
            const { size } = fs.statSync( file );
            all_size += size;
            console.log( size, byte_to_gb( all_size ) );
            console.log( 'delete', file );
          } );
        } ).catch( ( err ) => sentry.captureException( err ) );
        console.log( 'ох почищу щас' );
      }
    } ).catch( err => sentry.captureException( err ) );
  }, interval_msec );
}

function get_diskusage() {
  return new Promise( ( resolve, reject ) => {
    const disk_available_gb = hostinfo.get_disk_available_gb();
    console.log( 'disk_available_gb', disk_available_gb );
    if ( !disk_available_gb ) {
      return resolve( false );
    }
    some_diskusage()
      .then( ( usage ) => {
        resolve( byte_to_gb( usage.available ) < disk_available_gb )
      } )
      .catch( ( err ) => reject( err ) );
  } );
}

