const exec = require( 'child_process' ).exec;

module.exports = function diskusage( path ) {
  const find_path = path_parser( path );
  return new Promise( ( resolve, reject ) => {
    exec( 'WMIC VOLUME GET Name,FreeSpace,Capacity', ( err, stdout ) => {
      let rows = stdout.split( '\r\r\n' );
      const head = rows.shift().split( / +/g ).filter( ( v ) => v.length > 0 );
      let results = [];
      rows.forEach( ( row ) => {
        let row_parsed = row_parser( row );
        let result = {};
        if ( row_parsed.length !== 3 ) return;
        head.forEach( ( col_name, col_idx ) => {
          result[col_name] = row_parsed[col_idx];
        } )
        results.push( result );
      } );

      results.forEach( ( result ) => {
        if ( path_parser( result.Name ) === find_path ) {
          const total = parseInt( result.Capacity );
          const available = parseInt( result.FreeSpace );
          resolve( {
            total,
            available,
            used: total - available
          } );
        }
      } );
      resolve( 'path ' + path + ' not found' );
    } )
  } );
};

function row_parser( val ) {
  return val.split( / +/g ).filter( ( v ) => v.length > 0 );
}

function path_parser( val ) {
  return val.replace( /\\/g, '/' );
}