const sftp = require( './sftp' );
const sentry = require( './sentry' );
const fs = require( 'fs' );
const fileinfo = require( './fileinfo' );
const queue = [];
const events = {};
const MAX_WORKING_TIME = 60 * 60 * 1000; // час
let last_working_time = 0;
let state = 'waiting';
iterate();
module.exports = {
  add,
  on
};

function on( event, callback ) {
  if ( !events[event] ) events[event] = [];
  events[event].push( callback );
}

function emit( event, data ) {
  if ( events[event] ) {
    events[event].forEach( ( cb ) => {
      if ( typeof cb === 'function' ) {
        cb( data );
      }
    } );
  }
}

function add( item ) {
  if ( isWorking() ) return;
  const _item = queue.find( ( i ) => i.file === item.file );
  if ( !_item ) {
    console.log( 'QueueLoad.add', item );
    queue.push( item );
  }
}

function next() {
  const record = queue.shift();
  if ( record ) {
    working();
    return fs.access( record.file, fs.constants.R_OK, ( err ) => {
      if ( err ) {
        waiting();
        return emit( 'record_deleted', { record } );
      }
      fileinfo( record.file ).then( ( info ) => {
        record.fsize = info.size;
        emit( 'start_load', { record } );
        sftp.send_file( record.file, record.path, record.name + '.mkv' ).then( () => {
          waiting();
          emit( 'end_load', { record } );
        } ).catch( ( err ) => {
          waiting();
          emit( 'error_load', { record } );
          sentry.captureException( err );
        } );
      } ).catch( ( err ) => {
        console.log( err );
        waiting();
      } );
    } );
  }
  waiting();
}

function iterate() {
  const timeout = 1000 * 5;
  if ( isWorking() ) return setTimeout( iterate, timeout );
  next();
  setTimeout( iterate, timeout );
}

function working() {
  state = 'working';
  last_working_time = Date.now();
}

function waiting() {
  state = 'waiting';
}

function isWorking() {
  return state === 'working' && Date.now() - last_working_time < MAX_WORKING_TIME;
}