const sentry = require( './sentry' );
const app_config = require( './../configs/app_config' );
const fs = require( 'fs' );
const moment = require( 'moment' );
const fileinfo = require( './fileinfo' );
const getCountProcessByName = require( './../method/getCountProcessByName' );
const exec = require( 'child_process' ).execFile;
console.log( 'video screening' )
const FFMPEG_PATH = [ 'C:/Program Files (x86)/naumen/SoftPhone/ffmpeg.exe' ].find( ( path ) => fs.existsSync( path ) );
const USERNAME = require( 'os' ).userInfo().username;
const DURATION = 15 * 60;
if ( !FFMPEG_PATH ) {
  sentry.captureException( 'FFMPEG_PATH not found' );
  return;
}
monitoringScreeningProceccWorker();

function monitoringScreeningProcecc() {
  console.log( 'monitoringScreeningProcecc' )
  const PROCESS_NAME = 'ffmpeg.exe';
  return new Promise( ( resolve, reject ) => {
    getCountProcessByName( PROCESS_NAME ).then( ( count_process ) => {
      if ( !count_process ) {
        return runScreenProcess().finally( () => resolve() );
      }
      resolve();
    } ).catch( ( error ) => {
      console.log( 'send to sentry', error );
      reject( error );
    } );
  } );
}

function monitoringScreeningProceccWorker() {
  monitoringScreeningProcecc().finally( () => {
    setTimeout( monitoringScreeningProceccWorker, 1000 );
  } );
}

function runScreenProcess() {
  const DIR_DATE = moment().format( 'YYYY_MM_DD' )
  const TARGET_DIR = app_config.record_path() + '/' + DIR_DATE;
  const create_target_dir_if_not_exists = new Promise( ( resolve, reject ) => {
    fileinfo( TARGET_DIR ).then( ( stat ) => {
      resolve()
    } ).catch( ( error ) => {
      fs.mkdir( TARGET_DIR, { recursive: true }, ( error ) => {
        if ( error ) {
          return reject( error );
        }
        resolve();
      } );
    } );
  } );

  return new Promise( ( resolve, reject ) => {
    create_target_dir_if_not_exists.then( ( error ) => {
      if ( error ) return console.log( 'сообщить в сентри', error );
      console.log( 'screen recording' );
      const FILEEXT = 'mkv';
      const FILENAME = `(${ moment().format( 'HH-mm-ss' ) })(0)(${ USERNAME })`;
      const FILEFULLNAME = TARGET_DIR + '/' + `${ FILENAME }.${ FILEEXT }`;
      exec( FFMPEG_PATH, [ '-v', 'error', '-f', 'gdigrab', '-framerate', 5, '-i', 'desktop',
        '-vcodec', 'vp8', '-vb', '0.8M', '-auto-alt-ref', 0, '-deadline', 'realtime', '-r', 3, '-g', 4, '-qmin', 40, '-qmax', 50,
        '-vf', 'scale=-1:ih/1.428', '-acodec', 'libvorbis', '-t', DURATION, '-aq', 1, FILEFULLNAME ], ( error, data ) => {
        if ( error ) {
          console.log( 'send to sentry', error );
          return reject();
        }
        resolve();
      } );
    } );
  } );
}