const sftp = require( './sftp' );
const sentry = require( './sentry' );
const fs = require( 'fs' );
const fileinfo = require( './fileinfo' );
let CONFIG_SERVER = {};
const QUEUE = [];
const EVENTS = {};
const MAX_WORKING_TIME = 60 * 60 * 1000; // час
let last_working_time = 0;
let state = 'waiting';
iterate();
module.exports = {
  add,
  on,
  setConfigServer
};

function on( event, callback ) {
  if ( !EVENTS[event] ) EVENTS[event] = [];
  EVENTS[event].push( callback );
}

function emit( event, data ) {
  if ( EVENTS[event] ) {
    EVENTS[event].forEach( ( cb ) => {
      if ( typeof cb === 'function' ) {
        cb( data );
      }
    } );
  }
}

function add( item ) {
  QUEUE.push( item );
}

function iterate() {
  const timeout = 1000 * 5;
  if ( isWorking() ) return setTimeout( iterate, timeout );
  next();
  setTimeout( iterate, timeout );
}

function next() {
  if (!CONFIG_SERVER || Object.keys( CONFIG_SERVER ).length === 0 ) return waiting();
  const item = QUEUE.shift();
  console.log( 'CacheLoad.next', item );
  if ( item ) {
    working();
    return fs.access( item.file, fs.constants.R_OK, ( err ) => {
      if ( err ) {
        return waiting();
      }
      fileinfo( item.file ).then( ( info ) => {
        item.fsize = info.size;
        const file_path_parts = item.file.split( '/' );
        const path = file_path_parts[2];
        const name = file_path_parts[3];
        item.cache_path_file = path + '/' + name;
        sftp.sendFile( CONFIG_SERVER, item.file, path, name ).then( () => {
          waiting();
          emit( 'loadFileSuccess', item );
        } ).catch( ( err ) => {
          waiting();
          sentry.captureException( err );
        } );
      } ).catch( ( err ) => {
        sentry.captureException( err );
        waiting();
      } );
    } );
  }
  waiting();
}

function working() {
  state = 'working';
  last_working_time = Date.now();
}

function waiting() {
  state = 'waiting';
}

function isWorking() {
  return state === 'working' && Date.now() - last_working_time < MAX_WORKING_TIME;
}

function setConfigServer( config ) {
  CONFIG_SERVER = config;
}